/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.subdataset;

import it.businesslogic.ireport.SortField;
import it.businesslogic.ireport.SubDataset;
import it.businesslogic.ireport.gui.event.SubDatasetObjectChangedEvent;
import it.businesslogic.ireport.gui.subdataset.SortFieldCellRenderer;
import it.businesslogic.ireport.gui.subdataset.SortFieldDialog;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.Misc;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SortFieldsDialog
extends JDialog {
    private SubDataset subDataset;
    private JButton jButtonAdd;
    private JButton jButtonAscDesc;
    private JButton jButtonClose;
    private JButton jButtonModify;
    private JButton jButtonMoveDown;
    private JButton jButtonMoveUp;
    private JButton jButtonRemove;
    private JLabel jLabelSortBy;
    private JList jList1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;

    public SortFieldsDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initAll();
    }

    public SortFieldsDialog(Dialog parent, boolean modal) {
        super(parent, modal);
        this.initAll();
    }

    public void initAll() {
        this.initComponents();
        this.jList1.setModel(new DefaultListModel());
        Misc.centerFrame(this);
        this.jList1.setCellRenderer(new SortFieldCellRenderer());
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                SortFieldsDialog.this.jButtonCloseActionPerformed(e);
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        this.applyI18n();
        this.getRootPane().setDefaultButton(this.jButtonClose);
    }

    public void applyI18n() {
        this.setTitle(I18n.getString("sortFieldsDialog.title", "Sorting options"));
        this.jButtonClose.setText(I18n.getString("close", "Close"));
        this.jLabelSortBy.setText(I18n.getString("sortFieldsDialog.labelSortBy", "Sort by..."));
        this.jButtonAdd.setText(I18n.getString("sortFieldsDialog.buttonAdd", "Add field"));
        this.jButtonAscDesc.setText(I18n.getString("sortFieldsDialog.buttonAscDesc", "Asc / Desc"));
        this.jButtonModify.setText(I18n.getString("sortFieldsDialog.buttonModify", "Modify field"));
        this.jButtonMoveDown.setText(I18n.getString("sortFieldsDialog.buttonMoveDown", "Move down"));
        this.jButtonMoveUp.setText(I18n.getString("sortFieldsDialog.buttonMoveUp", "Move up"));
        this.jButtonRemove.setText(I18n.getString("sortFieldsDialog.buttonRemove", "Remove field"));
    }

    private void initComponents() {
        this.jLabelSortBy = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.jPanel1 = new JPanel();
        this.jButtonAdd = new JButton();
        this.jButtonModify = new JButton();
        this.jButtonRemove = new JButton();
        this.jButtonMoveUp = new JButton();
        this.jButtonMoveDown = new JButton();
        this.jButtonAscDesc = new JButton();
        this.jPanel2 = new JPanel();
        this.jButtonClose = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.setTitle("Sorting");
        this.jLabelSortBy.setHorizontalAlignment(2);
        this.jLabelSortBy.setText("Sort by...");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabelSortBy, gridBagConstraints);
        this.jScrollPane1.setPreferredSize(new Dimension(359, 260));
        this.jList1.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                SortFieldsDialog.this.jList1ValueChanged(evt);
            }
        });
        this.jList1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                SortFieldsDialog.this.jList1MouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.getContentPane().add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setMinimumSize(new Dimension(120, 10));
        this.jPanel1.setPreferredSize(new Dimension(120, 10));
        this.jButtonAdd.setText("Add field");
        this.jButtonAdd.setMaximumSize(new Dimension(200, 26));
        this.jButtonAdd.setMinimumSize(new Dimension(90, 26));
        this.jButtonAdd.setPreferredSize(new Dimension(120, 26));
        this.jButtonAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SortFieldsDialog.this.jButtonAddActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.jPanel1.add((Component)this.jButtonAdd, gridBagConstraints);
        this.jButtonModify.setText("Modify field");
        this.jButtonModify.setMaximumSize(new Dimension(200, 26));
        this.jButtonModify.setMinimumSize(new Dimension(90, 26));
        this.jButtonModify.setPreferredSize(new Dimension(120, 26));
        this.jButtonModify.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SortFieldsDialog.this.jButtonModifyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.jPanel1.add((Component)this.jButtonModify, gridBagConstraints);
        this.jButtonRemove.setText("Remove field");
        this.jButtonRemove.setMaximumSize(new Dimension(200, 26));
        this.jButtonRemove.setMinimumSize(new Dimension(90, 26));
        this.jButtonRemove.setPreferredSize(new Dimension(120, 26));
        this.jButtonRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SortFieldsDialog.this.jButtonRemoveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.jPanel1.add((Component)this.jButtonRemove, gridBagConstraints);
        this.jButtonMoveUp.setText("Move up");
        this.jButtonMoveUp.setMaximumSize(new Dimension(200, 26));
        this.jButtonMoveUp.setMinimumSize(new Dimension(90, 26));
        this.jButtonMoveUp.setPreferredSize(new Dimension(120, 26));
        this.jButtonMoveUp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SortFieldsDialog.this.jButtonMoveUpActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.jPanel1.add((Component)this.jButtonMoveUp, gridBagConstraints);
        this.jButtonMoveDown.setText("Move down");
        this.jButtonMoveDown.setMaximumSize(new Dimension(200, 26));
        this.jButtonMoveDown.setMinimumSize(new Dimension(90, 26));
        this.jButtonMoveDown.setPreferredSize(new Dimension(120, 26));
        this.jButtonMoveDown.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SortFieldsDialog.this.jButtonMoveDownActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.jPanel1.add((Component)this.jButtonMoveDown, gridBagConstraints);
        this.jButtonAscDesc.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/datasource/arrow_refresh.png")));
        this.jButtonAscDesc.setText("Asc / Desc");
        this.jButtonAscDesc.setMaximumSize(new Dimension(200, 26));
        this.jButtonAscDesc.setMinimumSize(new Dimension(90, 26));
        this.jButtonAscDesc.setPreferredSize(new Dimension(120, 26));
        this.jButtonAscDesc.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SortFieldsDialog.this.jButtonAscDescActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.jPanel1.add((Component)this.jButtonAscDesc, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        this.jButtonClose.setText("Close");
        this.jButtonClose.setMaximumSize(new Dimension(200, 26));
        this.jButtonClose.setMinimumSize(new Dimension(90, 26));
        this.jButtonClose.setPreferredSize(new Dimension(120, 26));
        this.jButtonClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SortFieldsDialog.this.jButtonCloseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        this.jPanel1.add((Component)this.jButtonClose, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 4, 4);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.pack();
    }

    private void jList1MouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            if (evt.getButton() == 1) {
                this.jButtonModifyActionPerformed(null);
            }
        }
    }

    private void jButtonAscDescActionPerformed(ActionEvent evt) {
        int[] items = this.jList1.getSelectedIndices();
        for (int i = 0; i < items.length; ++i) {
            SortField field;
            field.setDesc(!(field = (SortField)this.jList1.getModel().getElementAt(items[i])).isDesc());
            this.getSubDataset().fireSubDatasetObjectChangedListenerSubDatasetObjectChanged(new SubDatasetObjectChangedEvent(this.getSubDataset(), 5, 1, field, field));
        }
        this.jList1.updateUI();
    }

    private void jList1ValueChanged(ListSelectionEvent evt) {
        if (this.jList1.getSelectedIndex() >= 0) {
            this.jButtonAscDesc.setEnabled(true);
            this.jButtonModify.setEnabled(true);
            this.jButtonRemove.setEnabled(true);
            this.jButtonMoveUp.setEnabled(this.jList1.getSelectedIndex() > 0);
            this.jButtonMoveDown.setEnabled(this.jList1.getSelectedIndex() < ((DefaultListModel)this.jList1.getModel()).size() - 1);
        } else {
            this.jButtonAscDesc.setEnabled(false);
            this.jButtonModify.setEnabled(false);
            this.jButtonRemove.setEnabled(false);
            this.jButtonMoveUp.setEnabled(false);
            this.jButtonMoveDown.setEnabled(false);
        }
    }

    private void jButtonModifyActionPerformed(ActionEvent evt) {
        if (this.jList1.getSelectedIndex() >= 0) {
            SortField field = (SortField)this.jList1.getSelectedValue();
            SortFieldDialog sfd = new SortFieldDialog((Dialog)this, true);
            sfd.setSubDataset(this.getSubDataset());
            sfd.setSortField(field);
            sfd.setVisible(true);
            if (sfd.getDialogResult() == 0) {
                field.setFieldName(sfd.getSortField().getFieldName());
                field.setDesc(sfd.getSortField().isDesc());
                this.getSubDataset().fireSubDatasetObjectChangedListenerSubDatasetObjectChanged(new SubDatasetObjectChangedEvent(this.getSubDataset(), 5, 1, field, field));
                this.jList1.updateUI();
            }
        }
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void jButtonMoveUpActionPerformed(ActionEvent evt) {
        if (this.jList1.getSelectedValues() != null) {
            int[] indices = this.jList1.getSelectedIndices();
            for (int i = 0; i < indices.length; ++i) {
                if (indices[i] == 0) continue;
                Object val = ((DefaultListModel)this.jList1.getModel()).remove(indices[i]);
                ((DefaultListModel)this.jList1.getModel()).insertElementAt(val, indices[i] - 1);
                int n = i;
                indices[n] = indices[n] - 1;
            }
            this.jList1.setSelectedIndices(indices);
            this.getSubDataset().getSortFields().removeAllElements();
            DefaultListModel dlm = (DefaultListModel)this.jList1.getModel();
            for (int i = 0; i < dlm.getSize(); ++i) {
                this.getSubDataset().getSortFields().add(dlm.get(i));
            }
            this.getSubDataset().fireSubDatasetObjectChangedListenerSubDatasetObjectChanged(new SubDatasetObjectChangedEvent(this.getSubDataset(), 5, 1, null, null));
        }
    }

    private void jButtonMoveDownActionPerformed(ActionEvent evt) {
        if (this.jList1.getSelectedValues() != null) {
            int[] indices = this.jList1.getSelectedIndices();
            for (int i = indices.length - 1; i >= 0; --i) {
                if (indices[i] >= ((DefaultListModel)this.jList1.getModel()).size() - 1) continue;
                Object val = ((DefaultListModel)this.jList1.getModel()).remove(indices[i]);
                ((DefaultListModel)this.jList1.getModel()).insertElementAt(val, indices[i] + 1);
                int n = i;
                indices[n] = indices[n] + 1;
            }
            this.jList1.setSelectedIndices(indices);
            this.getSubDataset().getSortFields().removeAllElements();
            DefaultListModel dlm = (DefaultListModel)this.jList1.getModel();
            for (int i = 0; i < dlm.getSize(); ++i) {
                this.getSubDataset().getSortFields().add(dlm.get(i));
            }
            this.getSubDataset().fireSubDatasetObjectChangedListenerSubDatasetObjectChanged(new SubDatasetObjectChangedEvent(this.getSubDataset(), 5, 1, null, null));
        }
    }

    private void jButtonRemoveActionPerformed(ActionEvent evt) {
        if (this.jList1.getSelectedValues() != null) {
            Object[] values = this.jList1.getSelectedValues();
            for (int i = 0; i < values.length; ++i) {
                SortField field = (SortField)values[i];
                ((DefaultListModel)this.jList1.getModel()).removeElement(field);
                this.getSubDataset().removeSortField(field);
            }
        }
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        SortFieldDialog jrpd = new SortFieldDialog((Dialog)this, true);
        jrpd.setSubDataset(this.getSubDataset());
        jrpd.setVisible(true);
        if (jrpd.getDialogResult() == 0) {
            SortField field = jrpd.getSortField();
            ((DefaultListModel)this.jList1.getModel()).addElement(field);
            this.getSubDataset().addSortField(field);
        }
    }

    public SubDataset getSubDataset() {
        return this.subDataset;
    }

    public void setSubDataset(SubDataset subDataset) {
        this.subDataset = subDataset;
        Vector cp = subDataset.getSortFields();
        for (int i = 0; i < cp.size(); ++i) {
            ((DefaultListModel)this.jList1.getModel()).addElement((SortField)cp.elementAt(i));
        }
    }
}

