/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport;

import it.businesslogic.ireport.GraphicReportElement;
import it.businesslogic.ireport.ReportElement;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;

public class LineReportElement
extends GraphicReportElement {
    public String direction;

    public LineReportElement(int x, int y, int width, int height) {
        this(x, y, width, height, "whatever");
        if (width * height >= 0) {
            this.setDirection("TopDown");
        } else {
            this.setDirection("BottomUp");
        }
    }

    public LineReportElement(int x, int y, int width, int height, String direction) {
        super(x, y, Math.abs(width), Math.abs(height));
        this.direction = direction;
        this.setKey("line");
    }

    public void drawObject(Graphics2D g, double zoom_factor, int x_shift_origin, int y_shift_origin) {
        Stroke stroke;
        this.zoom_factor = zoom_factor;
        int height_draw = 0;
        height_draw = this.height <= 1 ? 0 : this.height - 1;
        int width_draw = 0;
        width_draw = this.width <= 1 ? 0 : this.width - 1;
        Point a = new Point(this.getZoomedDim(this.position.x - 10) + 10 - x_shift_origin, this.getZoomedDim(this.position.y - 10) + 10 - y_shift_origin);
        Point b = new Point(this.getZoomedDim(this.position.x + width_draw - 10) + 10 - x_shift_origin, this.getZoomedDim(this.position.y + height_draw - 10) + 10 - y_shift_origin);
        if (!this.direction.equalsIgnoreCase("TopDown")) {
            b.y = this.getZoomedDim(this.position.y - 10) + 10 - y_shift_origin;
            a.y = this.getZoomedDim(this.position.y + this.height - 10) + 10 - y_shift_origin;
        }
        if ((stroke = LineReportElement.getPenStroke(this.getGraphicElementPen(), this.getPen(), zoom_factor)) != null) {
            Stroke oldStroke = g.getStroke();
            g.setStroke(stroke);
            g.setColor(this.getFgcolor());
            g.drawLine(a.x, a.y, b.x, b.y);
            g.setStroke(oldStroke);
        }
    }

    public ReportElement cloneMe() {
        LineReportElement newReportElement = new LineReportElement(this.position.x, this.position.y, this.width, this.height);
        this.copyBaseReportElement(newReportElement, this);
        return newReportElement;
    }

    public String getDirection() {
        return this.direction;
    }

    public void setDirection(String direction) {
        this.direction = direction;
    }

    public void copyBaseReportElement(ReportElement destination, ReportElement source) {
        super.copyBaseReportElement(destination, source);
        if (destination instanceof LineReportElement && source instanceof LineReportElement) {
            ((LineReportElement)destination).setDirection(new String(((LineReportElement)source).getDirection()));
        }
    }

    public boolean insideBand() {
        int r_height;
        int n = r_height = this.height == 0 ? 1 : this.height;
        if (this.band == null) {
            return false;
        }
        int yband = this.band.getBandYLocation();
        if (this.position.y - yband + r_height > this.band.getHeight()) {
            return false;
        }
        return super.insideBand();
    }
}

