/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.webcam;

import com.github.sarxos.webcam.Webcam;
import com.github.sarxos.webcam.WebcamEvent;
import com.github.sarxos.webcam.WebcamExceptionHandler;
import com.github.sarxos.webcam.WebcamListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebcamStreamer
implements ThreadFactory,
WebcamListener {
    private static final Logger LOG = LoggerFactory.getLogger(WebcamStreamer.class);
    private static final String BOUNDARY = "mjpegframe";
    private Webcam webcam = null;
    private double fps = 0.0;
    private BufferedImage image = null;
    private Object lock = new Object();
    private int number = 0;
    private int port = 0;
    private Executor executor = Executors.newCachedThreadPool(this);
    private AtomicBoolean open = new AtomicBoolean(false);
    private AtomicBoolean initialized = new AtomicBoolean(false);

    public WebcamStreamer(int port, Webcam webcam, double fps, boolean start) {
        if (webcam == null) {
            throw new IllegalArgumentException("Webcam for streaming cannot be null");
        }
        this.port = port;
        this.webcam = webcam;
        this.fps = fps;
        if (start) {
            this.start();
        }
    }

    private long getDelay() {
        return (long)(1000.0 / this.fps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage getImage() {
        if (this.image == null) {
            Object object = this.lock;
            synchronized (object) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException e) {
                    LOG.error("Nasty interrupted exception", (Throwable)e);
                }
                catch (Exception e) {
                    throw new RuntimeException("Problem waiting on lock", e);
                }
            }
        }
        return this.image;
    }

    public void start() {
        if (this.open.compareAndSet(false, true)) {
            this.webcam.addWebcamListener(this);
            this.webcam.open();
        }
    }

    public Thread newThread(Runnable r) {
        Thread thread = new Thread(r, String.format("streamer-thread-%s", this.number++));
        thread.setUncaughtExceptionHandler(WebcamExceptionHandler.getInstance());
        thread.setDaemon(true);
        return thread;
    }

    public void webcamOpen(WebcamEvent we) {
        if (this.initialized.compareAndSet(false, true)) {
            this.executor.execute(new Acceptor());
            this.executor.execute(new Reader());
        }
    }

    public void webcamClosed(WebcamEvent we) {
    }

    public void webcamDisposed(WebcamEvent we) {
    }

    public void webcamImageObtained(WebcamEvent we) {
    }

    public static void main(String[] args) throws InterruptedException {
        new WebcamStreamer(8081, Webcam.getDefault(), 0.5, true);
        while (true) {
            Thread.sleep(1000L);
        }
    }

    private class Connection
    implements Runnable {
        private static final String CRLF = "\r\n";
        private Socket socket = null;

        public Connection(Socket socket) {
            this.socket = socket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            BufferedReader br = null;
            FilterOutputStream bos = null;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                br = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
                bos = new BufferedOutputStream(this.socket.getOutputStream());
                try {
                    block26: while (WebcamStreamer.this.webcam.isOpen()) {
                        if (this.socket.isInputShutdown()) {
                            break;
                        }
                        if (this.socket.isClosed()) {
                            break;
                        }
                        String line = br.readLine();
                        if (line == null || line.isEmpty()) {
                            bos.write("--mjpegframe--\r\n".getBytes());
                            LOG.info("Breaking");
                            break;
                        }
                        if (!line.startsWith("GET")) continue;
                        this.socket.setSoTimeout(0);
                        this.socket.setKeepAlive(true);
                        WebcamStreamer.this.getImage();
                        StringBuilder sb = new StringBuilder();
                        sb.append("HTTP/1.0 200 OK").append(CRLF);
                        sb.append("Connection: keep-alive").append(CRLF);
                        sb.append("Cache-Control: no-cache").append(CRLF);
                        sb.append("Cache-Control: private").append(CRLF);
                        sb.append("Pragma: no-cache").append(CRLF);
                        sb.append("Content-type: multipart/x-mixed-replace; boundary=--").append(WebcamStreamer.BOUNDARY).append(CRLF);
                        sb.append(CRLF);
                        bos.write(sb.toString().getBytes());
                        while (!this.socket.isInputShutdown() && !this.socket.isClosed()) {
                            block37: {
                                baos.reset();
                                ImageIO.write((RenderedImage)WebcamStreamer.this.getImage(), "JPG", baos);
                                sb.delete(0, sb.length());
                                sb.append("--").append(WebcamStreamer.BOUNDARY).append(CRLF);
                                sb.append("Content-type: image/jpeg").append(CRLF);
                                sb.append("Content-Length: ").append(baos.size()).append(CRLF);
                                sb.append(CRLF);
                                bos.write(sb.toString().getBytes());
                                bos.write(baos.toByteArray());
                                bos.write(CRLF.getBytes());
                                try {
                                    ((BufferedOutputStream)bos).flush();
                                }
                                catch (SocketException e) {
                                    if (!LOG.isTraceEnabled()) break block37;
                                    LOG.error("Socket exception", (Throwable)e);
                                }
                            }
                            Thread.sleep(WebcamStreamer.this.getDelay());
                            if (WebcamStreamer.this.webcam.isOpen()) continue;
                            continue block26;
                        }
                    }
                }
                catch (Exception e) {
                    String message = e.getMessage();
                    if (message != null && message.startsWith("Software caused connection abort")) {
                        LOG.info("User closed stream");
                        if (br != null) {
                            try {
                                br.close();
                            }
                            catch (IOException e2) {
                                LOG.error("Cannot close buffered reader", (Throwable)e2);
                            }
                        }
                        if (bos != null) {
                            try {
                                bos.close();
                            }
                            catch (IOException e3) {
                                LOG.error("Cannot close data output stream", (Throwable)e3);
                            }
                        }
                        return;
                    }
                    try {
                        LOG.error("Error", (Throwable)e);
                        bos.write("HTTP/1.0 501 Internal Server Error\r\n\r\n\r\n".getBytes());
                    }
                    catch (IOException e4) {
                        LOG.error("I/O exception", (Throwable)e4);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        LOG.error("Cannot close buffered reader", (Throwable)e);
                    }
                }
                if (bos != null) {
                    try {
                        bos.close();
                    }
                    catch (IOException e) {
                        LOG.error("Cannot close data output stream", (Throwable)e);
                    }
                }
            }
        }
    }

    private class Reader
    implements Runnable {
        private Reader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (WebcamStreamer.this.webcam.isOpen()) {
                WebcamStreamer.this.image = WebcamStreamer.this.webcam.getImage();
                if (WebcamStreamer.this.image != null) {
                    Object object = WebcamStreamer.this.lock;
                    synchronized (object) {
                        WebcamStreamer.this.lock.notifyAll();
                    }
                }
                try {
                    Thread.sleep(WebcamStreamer.this.getDelay());
                }
                catch (InterruptedException e) {
                    LOG.error("Nasty interrupted exception", (Throwable)e);
                }
            }
        }
    }

    private class Acceptor
    implements Runnable {
        private Acceptor() {
        }

        public void run() {
            try {
                ServerSocket server = new ServerSocket(WebcamStreamer.this.port);
                while (true) {
                    WebcamStreamer.this.executor.execute(new Connection(server.accept()));
                }
            }
            catch (Exception e) {
                LOG.error("Cannot accept socket connection", (Throwable)e);
                return;
            }
        }
    }
}

