/*
 * Decompiled with CFR 0.152.
 */
package com.topaz.sigplus.util;

import com.topaz.sigplus.util.SigDataType;
import com.topaz.sigplus.util.SigDrawParameters;
import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public class SigGraphics {
    boolean jdk12;
    Graphics g;
    private double[][] transform = new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}};

    public SigGraphics(Graphics gToUse) {
        this.g = gToUse;
        if (this.g == null) {
            this.jdk12 = false;
        } else {
            this.jdk12 = true;
            try {
                Class<?> theClass = Class.forName("java.awt.Graphics2D");
            }
            catch (ClassNotFoundException e) {
                this.jdk12 = false;
            }
        }
    }

    private void applyTransform(double[][] trans) {
        double[][] newTrans = new double[][]{new double[3], new double[3], new double[3]};
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                double term = 0.0;
                int k = 0;
                while (k < 3) {
                    term += this.transform[i][k] * trans[k][j];
                    ++k;
                }
                newTrans[i][j] = term;
                ++j;
            }
            ++i;
        }
        this.transform = newTrans;
    }

    public int transformX(double x, double y) {
        double newX = this.transform[0][0] * x + this.transform[0][1] * y + this.transform[0][2];
        return (int)newX;
    }

    public int transformY(double x, double y) {
        double newY = this.transform[1][0] * x + this.transform[1][1] * y + this.transform[1][2];
        return (int)newY;
    }

    public void scale(double sX, double sY) {
        if (this.jdk12) {
            Graphics2D g2d = (Graphics2D)this.g;
            g2d.scale(sX, sY);
        } else {
            double[][] newTrans = new double[][]{{sX, 0.0, 0.0}, {0.0, sY, 0.0}, {0.0, 0.0, 1.0}};
            this.applyTransform(newTrans);
        }
    }

    public void translate(double tX, double tY) {
        if (this.jdk12) {
            Graphics2D g2d = (Graphics2D)this.g;
            g2d.translate(tX, tY);
        } else {
            double[][] newTrans = new double[][]{{1.0, 0.0, tX}, {0.0, 1.0, tY}, {0.0, 0.0, 1.0}};
            this.applyTransform(newTrans);
        }
    }

    public void rotate(double theta) {
        if (this.jdk12) {
            Graphics2D g2d = (Graphics2D)this.g;
            g2d.rotate(theta);
        } else {
            double sinTheta = Math.sin(theta);
            double cosTheta = Math.cos(theta);
            double[][] newTrans = new double[][]{{cosTheta, sinTheta, 0.0}, {-sinTheta, cosTheta, 0.0}, {0.0, 0.0, 1.0}};
            this.applyTransform(newTrans);
        }
    }

    public void setPenWidth(float width) {
        if (this.jdk12) {
            Graphics2D g2d = (Graphics2D)this.g;
            BasicStroke penStroke = new BasicStroke(width);
            g2d.setStroke(penStroke);
        }
    }

    public void drawLine(double x1, double y1, double x2, double y2) {
        if (this.jdk12) {
            Graphics2D g2d = (Graphics2D)this.g;
            Line2D.Double line = new Line2D.Double(x1, y1, x2, y2);
            g2d.draw(line);
        } else {
            int startX = this.transformX(x1, y1);
            int startY = this.transformY(x1, y1);
            int stopX = this.transformX(x2, y2);
            int stopY = this.transformY(x2, y2);
            this.g.drawLine(startX, startY, stopX, stopY);
        }
    }

    void drawTimeStamp(SigDataType sig, SigDrawParameters params) {
        if (this.jdk12) {
            int fontY;
            Graphics2D g2D = (Graphics2D)this.g;
            FontRenderContext frc = new FontRenderContext(null, false, false);
            if (!params.drawTimeStamp || sig.timeStamp == null || sig.timeStamp.length() == 0) {
                return;
            }
            int fontSize = params.drawTimeStampSize == 0 ? 75 * params.drawYSize / 1000 : params.drawTimeStampSize;
            Font fnt = new Font("Dialog", 0, fontSize);
            TextLayout layout = new TextLayout(sig.timeStamp, fnt, frc);
            int fontX = params.drawTimeStampX == 0 ? 50 * params.drawXSize / 1000 : params.drawTimeStampX;
            if (params.drawTimeStampY == 0) {
                fontY = 50 * params.drawYSize / 1000;
                fontY = params.drawYSize - fontY;
            } else {
                fontY = params.drawTimeStampY;
            }
            layout.draw(g2D, fontX, fontY);
        }
    }

    void drawAnnotation(SigDataType sig, SigDrawParameters params) {
        if (this.jdk12) {
            int fontY;
            int fontX;
            Graphics2D g2D = (Graphics2D)this.g;
            FontRenderContext frc = new FontRenderContext(null, false, false);
            if (!params.drawAnnotation || sig.annotation == null || sig.annotation.length() == 0) {
                return;
            }
            int fontSize = params.drawAnnotationSize == 0 ? 75 * params.drawYSize / 1000 : params.drawAnnotationSize;
            Font fnt = new Font("Dialog", 0, fontSize);
            TextLayout layout = new TextLayout(sig.annotation, fnt, frc);
            if (params.drawAnnotationX == 0) {
                Rectangle2D bounds = layout.getBounds();
                fontX = 50 * params.drawXSize / 1000;
                fontX = params.drawXSize - fontX - (int)bounds.getWidth();
            } else {
                fontX = params.drawAnnotationX;
            }
            if (params.drawAnnotationY == 0) {
                fontY = 50 * params.drawYSize / 1000;
                fontY = params.drawYSize - fontY;
            } else {
                fontY = params.drawAnnotationY;
            }
            layout.draw(g2D, fontX, fontY);
        }
    }
}

